//
//  MCInspectorCenter.h
//  MCApplication
//
//  Created by aj on Wed Sep 26 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MCInspectorCenter : NSObject {

}

// Asks the surveyor for stuff
+ (void)registerInspectorsFromSurveyor;

// 
// Registers available inspectors
+ (void)registerInspectorClassname:(NSString *)inspectName forClassname:(NSString *)aClassname;

//
// Returns the appropriate inspector name for a given object. If anObject is nil 
// or if there is no inspector the given class then 'MCInspector' is returned.
// MCInspector implements the 'no info' panel.
+ (NSString *)inspectorNameForObject:(id)anObject;
+ (NSString *)inspectorNameForClassname:(NSString *)aName;

+ (NSArray *)inspectorControls;

//
// Creates a retained inspector window -- it should be released when the window is closed
+ (id)newOrRecycledInspectorControl;
//
// Returns the inspectorControl(s) that is inspected anObject, nil if the object is not inspected
+ (NSArray *)inspectorControlsForObject:(id)anObject;
//
// If anObject is already being inspected, then the inspectorControl 
// inspecting it is returned, otherwise a new or recycled one is returned
+ (id)newOrRecycledInspectorControlForObject:(id)anObject;
+ (void)recycleInspectorControl:(id)aControl;

//
// Returns an autoreleased inspector or the 'empty' inspector if 
// there isn't one registered for that class
+ (id)newInspectorForClassnamed:(NSString *)aName;
+ (id)newInspectorForClass:(Class)aClass;
+ (id)newInspectorForObject:(id)anObject;

@end
